TITLE	Einfaches Hotkeyprogramm (C) Interest Verlag 1990


; -------------------------------------------
; - Makrodefinitionen zur Registersicherung -
; -------------------------------------------

    	PUSHALL MACRO		;Alle Register sichern
	PUSHF
	PUSH AX
	PUSH BX
	PUSH CX
	PUSH DX
	PUSH DS
	PUSH ES
	PUSH DI
	PUSH SI
	PUSH BP
	ENDM

	POPALL MACRO		;Alle Register restaurieren
	POP BP
	POP SI
	POP DI
	POP ES
	POP DS
	POP DX
	POP CX
	POP BX
	POP AX
	POPF
	ENDM

; -------------------------------------------------------------

ASSUME CS:CODE,DS:CODE		;Segmentierung fr COM-Modell
ASSUME ES:NOTHING,SS:NOTHING

CODE	SEGMENT
	ORG 100H		;Startadresse

BEGINN:	JMP INSTAL		;Installation anspringen

; ------------------------------------
; - Variablentabelle residenter Teil -
; ------------------------------------

	DB 512 DUP (0)
ABLAGE	EQU $			;vordefinierter Stack
ALTINT	DD 0			;Alter Interrupt 09H
ALTI13	DD 0			;Alter Interrupt 13H
ALTI10	DD 0			;Alter Interrupt 10H
ALTI28	DD 0			;Alter Interrupt 28H
INDOSS	DD 0			;Adresse Indosflag
ALTSP	DW 0			;Stackpointer alt
ALTSS	DW 0			;Stacksegment alt
AKTIV	DB 0			;Interrupt-Flag des residenten Programmes
ALT13	DB 0			;Interrupt-Flag Diskette/Festplatte
ALT10	DB 0			;Interrupt-Flag Video
BREAK	DB 0			;CTRL+C Abbruch verhindern
MODUS	DB 0,1,2,3,7		;zulssige Videomodi
FORM	DW 0			;alte Cursorform
POSI	DW 0			;alte Cursorposition
WARTEN	DB 0			;Aktivierung ber Videointerrupt
NEU28C	DB 0			;Aktivierung ber DOS
SEITE	DB 0			;aktive Bildschirmseite
ATTRIB	DB 0			;Attribut der Ausgabe
PRUEF	DB "H. Schkel 1990"	;Prfstring
AUSGAB	DB "HOTKEY-V. 1.00(C) Interest Verlagķ",0
	DB "    Bettigen Sie jetzt eine Taste    ",0
	DB "Ľ",0
PUFFER	DB 40*2*3 DUP (0)	;Bildschirminhalt sichern

; --------------------------------------------
; - Hier sind die Interrupt-Handler abgelegt -
; --------------------------------------------

NEU13	PROC FAR		;Handler fr Interrupt 13H
	MOV CS:[ALT13],1
	PUSHF
	CALL CS:[ALTI13]	;alten Handler aufrufen
	MOV CS:[ALT13],0
	RET 2			;zurck ohne FLAG restaurieren

NEU13	ENDP

; -------------------------------------------------------------

NEU10	PROC FAR		;Handler fr Interrupt 10H
	MOV CS:[ALT10],1
	PUSHF
	CALL CS:[ALTI10]	;alten Handler aufrufen
	CLI			;Interrupts sperren
	MOV CS:[ALT10],0
	CMP BYTE PTR CS:[WARTEN],1	;Wartet das Programm ?
	JZ INT10		;Ja, aufrufen
INT10R:	IRET
INT10:	MOV CS:[WARTEN],0	;Wartestellung aufheben
	CMP CS:[AKTIV],1	;Programm schon aktiv
	JZ INT10R		;Ja, raus
	PUSH AX			;relevante Register sichern
	PUSH BX
	PUSH DX
	PUSH DS
	JMP SHORT INT9EA	;Versuch tatschlicher Aktivierung


NEU10	ENDP

; ------------------------------------------------
; - Versuch der Aktivierung der ON-LINE-HILFE !! -
; ------------------------------------------------

NEU28	PROC FAR		;Aktivierungsversuch ber DOS
	PUSHF
	CALL CS:[ALTI28]	;Alten Interrupt abarbeiten
	CLI			;Interrupts sperren
	MOV CS:[NEU28C],1	;Aufruf ber DOS deklarieren
	JMP SHORT NEU28A	;und versuchen zu aktivieren

NEU28	ENDP

; -----------------------------------------

NEUADR	PROC FAR		;Handler & Aktivierung ber INT 09H
	PUSHF
	CALL CS:[ALTINT]	;Alten Interrupt abarbeiten
NEU28A:	CMP CS:[AKTIV],1	;Programm schon aktiv
	JNZ NEUAD1		;Nein, weiter
	IRET			;erster Rcksprung
NEUAD1:	CLI			;Interrupts sperren
	PUSH AX			;relevante Register sichern
	PUSH BX
	PUSH DX
	PUSH DS
	MOV AX,40H		;Segment des Tastaturbuffers
	MOV DS,AX
	MOV DX,WORD PTR DS:[01CH]	;letztes Zeichen
	MOV BX,WORD PTR DS:[01AH]	;letztes zu lesendes Zeichen
	CMP DX,BX		;gleiche Werte = kein Zeichen vorhanden
	JZ RUCK			;Ja, Raus
	MOV AX,[BX]		;Zeichen aus Buffer
	CMP AX,3200H		;Hotkeytaste ALT+M
	JNZ RUCK		;Nein, Raus
	MOV DS:[01AH],DX	;Tastaturbuffer lschen

INT9EA:	CMP CS:[ALT10],1	;Aktive Zeichenausgabe
	JNZ RUCK1		;Nein, weiter
	MOV CS:[WARTEN],1	;Aufruf ber INT10H versuchen
	JMP SHORT RUCK		;jetzt zurck	

RUCK1:	CMP CS:[ALT13],1	;Aktiver Diskettenzugriff
	JZ RUCK			;Ja, Raus

	CMP CS:[NEU28C],0	;Aufrufflag gelscht
	MOV CS:[NEU28C],0	;gleich lschen
	JNZ WEIT5		;Nein, aufrufen
	LDS BX,CS:[INDOSS]	;Indosflag prfen
	CMP BYTE PTR [BX],0	;prfen
	JZ WEIT5		;Nicht aktiv, dann weiter

RUCK:	POP DS			;Register restaurieren
	POP DX
	POP BX
	POP AX
	IRET

NEUADR ENDP

; ----------------------------------------------------------------
; - Systemabhngige Routinen stehen der Aktivierung nicht im Weg -
; ----------------------------------------------------------------

WEIT5	PROC NEAR		;das ganze restl. Programm ist Near
	MOV CS:[AKTIV],1	;Programm als Aktiv deklarieren
	POP DS			;fremden Stack bereinigen
	POP DX
	POP BX
	POP AX
	MOV WORD PTR CS:[ALTSS],SS	;Stacksegment sichern
	MOV WORD PTR CS:[ALTSP],SP	;Stackpointer sichern
	PUSH CS
	POP SS			;Stacksegment setzen
	MOV SP,OFFSET ABLAGE	;Stackpointer auf eigene Stackadresse
	PUSHALL			;alle Register sichern
	LDS SI,DWORD PTR CS:[ALTSP]	;Stack Vaterproze sichern
	MOV CX,64		;Anzahl Durchlufe
WEIT5A:  PUSH WORD PTR DS:[SI]
	  INC SI
	  INC SI
	 LOOP WEIT5A
	PUSH CS			;Datensegment
	POP DS			;wie Codesegment (COM-Modell)

; -------------------------------------------------------------

				;Textmodus aktiv prfen
	MOV AH,0FH		;Videomodus auslesen
	INT 10H
	MOV [SEITE],BH		;aktuelle Bildschirmseite
	PUSH CS			;Extrasegment setzen
	POP ES
	CLD			;aufsteigende Stringbearbeitung
	MOV DI,OFFSET MODUS	;Offset der zulssigen Modi
	MOV CX,5		;Anzahl der vorhandenen Modi
	REPNZ SCASB		;und Byteweise prfen, prfen, prfen !!!
	JZ ZULASS		;Ja, zulssig dann weiter

				;Falscher Modus !!
	CALL TON		;BEEP ausgeben
	JMP STAP1B		;und Ende

; -------------------------------------------------------------

ZULASS:	MOV AX,3300H		;Break Flag lesen
	INT 21H
	MOV [BREAK],DL		;und ablegen
	MOV AX,3301H		;Break Flag lschen
	XOR DL,DL
	INT 21H			;erledigt

; -------------------------------------------------------------

	MOV BH,[SEITE]		;Cursorform auslesen
	MOV AH,03H
	INT 10H			;Cursorform nun in CX
	MOV [FORM],CX		;und sichern
	MOV [POSI],DX		;Position sichern

; -------------------------------------------------------------

	MOV SI,OFFSET PUFFER	;Bufferadresse f. Bildinhalt
	MOV DH,255		;Zeile 0 abzglich 1
	MOV CX,3		;3 Zeilen lesen
WHILE:	 XOR DL,DL		;Spalte 0 einstellen
	  INC DH		;Zeile erhhen
	   MOV BH,[SEITE]	;aktuelle Bildschirmseite
	    MOV AH,02H
	     INT 10H		;Cursor positionieren
	      PUSH CX		;Zeichenanzahl sichern
	       MOV CX,40	;40 Zeichen lesen (80 Byte)
WHILE1:	  PUSH SI		;Adresse sichern
	   MOV AH,08H		;Zeichen von Cursorposition
	    INT 10H		;lesen
	     POP SI		;Adresse holen
	       MOV [SI],AX	;Attribut und Zeichen ablegen
	        INC DL		;Spalte erhhen
	       INC SI		;Zeiger aktualisieren
	      INC SI
	     PUSH SI		;und auf Stapel
	    MOV AH,02H		;Cursor positionieren
	   INT 10H
	  POP SI		;Zeiger holen
	 LOOP WHILE1		;und von vorn
	  POP CX		;Wert erste Schleife holen
	 LOOP WHILE		;und nchste Zeile

; -------------------------------------------------------------

	XOR DX,DX		;Cursor positionieren
	MOV SI,OFFSET AUSGAB	;Erste Zeile
	CALL PRINT		;Uberschrift ausgeben
	INC DH			;Cursorposition
	CALL PRIN		;und ausgeben
	INC DH			;Zeile 3
	CALL PRIN		;und ausgeben
	CALL TON		;BEEP ausgeben

; -------------------------------------------------------------

	MOV AX,0C07H		;DOS-Eingabefunktion
	INT 21H			;aufrufen
	CALL TON		;einmal BEEP'en

; -------------------------------------------------------------

				;Bildschirm restaurieren
	CLD			;aufsteigende Stringbearbeitung
	MOV SI,OFFSET PUFFER	;Zwischenadresse
	MOV BH,[SEITE]		;aktuelle Bildschirmseite
	MOV CX,3		;3 Zeilen insgesamt
	MOV DH,255		;Zeile 0 abzglich

BILD1:	XOR DL,DL		;Spalte 0
	 INC DH			;Zeile erhhen
	  PUSH CX		;Schleifenzhler Nr. 1 sichern
	   MOV CX,40		;40 Zeichen ausgeben
BILD2:      PUSH SI		;Zwischenadresse sichern
	     MOV AH,02H		;Cursor positionieren
	      INT 10H
	       POP SI		;Adresse holen
	        LODSW		;2 Byte aus Buffer
	         MOV BL,AH	;Attribut tauschen
	         PUSH SI	;Adresse wieder rauf
	         PUSH CX	;Schleifenzhler Nr. 2 sichern
	        MOV CX,1	;je ein Zeichen
	       MOV AH,09H	;Zeichen und Atrribut ausgeben
	      INT 10H
	     POP CX		;Schleifenzhler zurck
	    POP SI		;Adresse zurck
	   INC DL		;Spalte erhhen
	  LOOP BILD2		;nchstes Zeichen
	 POP CX			;Schleifenzhler Nr. 1
	LOOP BILD1		;nchste Zeile

; -------------------------------------
; - Ende des Aufrufes residenter Teil -
; -------------------------------------

	CLI			;Interrupts sperren
	MOV AH,01H		;Cursorpos. + Form wiederherstellen
	MOV CX,[FORM]
	INT 10H
	MOV AH,02H
	MOV BH,[SEITE]
	MOV DX,[POSI]
	INT 10H
	CLI			;Interrupts sperren
	MOV AX,3301H		;Breakflag auf alten Wert
	MOV DL,[BREAK]
	INT 21H			;erledigt

; -------------------------------

STAP1B:	CLI			;alten Stack restaurieren
	LDS SI,DWORD PTR CS:[ALTSP]
	ADD SI,128
	MOV CX,64
STAP1A:  DEC SI			;Mu wegen eventueller unterbrochener
	  DEC SI		;DOS-Funktion durchgefhrt werden
	  POP WORD PTR DS:[SI]
	 LOOP STAP1A
	POPALL
	MOV SS,WORD PTR CS:[ALTSS]
	MOV SP,WORD PTR CS:[ALTSP]
	MOV CS:[AKTIV],0	;Programm nicht mehr aktiv

	IRET			;zuruck zur Aufrufebene

; ----------------------------------------
; - Unterprogramme des residenten Teiles -
; ----------------------------------------

; -------------------------
; - Ersatz der Tonausgabe -
; -------------------------

TON:	PUSH AX			;bentigte Register sichern
	PUSH CX
	MOV AL,182		;Ausgaberegister des Timerbausteines
	OUT 43H,AL		;vorbereiten
	MOV AX,2712		;Kammerton "A" eintragen
	OUT 42H,AL
	MOV AL,AH		;das hherwertige Byte
	OUT 42H,AL		;eintragen
	IN AL,61H		;PPI Inhalt ermitteln
	MOV AH,AL
	OR AL,3			;auf Ausgabe schalten
	OUT 61H,AL		;und Ton ausgeben
	MOV CX,5000
TON1:	LOOP TON1
	MOV AL,AH		;Ursprungs-PPI
	OUT 61H,AL		;restaurieren
	POP CX
	POP AX			;Register zurck
	RET			;Rcksprung

; ---------------------------------------------
; - Zeile aus Puffer auf dem Monitor ausgeben -
; ---------------------------------------------

PRINT:				;Einsprung: In DX die Ausgabekoordinaten
				;	    In SI der Ausgabeoffset
				;Aussprung: Keine

	MOV BL,BYTE PTR [PUFFER+1]	;Attribut verndern
	NOT BL			;invertieren
	TEST BL,00000001B	;wegen der HGC-Graphikkarte
	MOV BL,00001111B	;erst mal so !!!
	JNZ GLEICH		;doch anders
	MOV BL,01110000B
GLEICH:	MOV [ATTRIB],BL		;und sichern
PRIN:	PUSH DX			;Koordinaten sichern
	MOV BL,[ATTRIB]		;fr zweiten und dritten Aufruf
	MOV BH,[SEITE]		;aktuelle Bildschirmseite holen
	MOV CX,1		;nur ein Zeichen
	CLD			;aufsteigende Stringbearbeitung

PRINT1:	 PUSH SI
	  MOV AH,02H		;Cursor positionieren
	   INT 10H
	    INC DL		;Spalte anpassen
	     POP SI
	      LODSB
	       CMP AL,0		;Ende erreicht ?
	      JZ ENDPRI		;Ja, dann raus
	     PUSH SI
	    MOV AH,09H		;Zeichen ausgeben
	   INT 10H
	  POP SI
	 JMP SHORT PRINT1

ENDPRI:	MOV DX,50FFH		;Cursor ausschalten
	MOV BH,[SEITE]		;sonst funktioniert es nicht immer
	MOV AH,02H
	INT 10H			;fertig des Ausschaltens
	POP DX			;Koordinaten zurck
	RET			;Rcksprung

; ----------------------------------
; - Hier ist der Installationsteil -
; ----------------------------------

INSTAL:				;Erster Aufruf = Installation
				;Zweiter Aufruf = Reinstallation

	PUSH CS			;Datensegment setzen
	POP DS
	CALL INSPRU		;Vektoren berprfen
	CMP BYTE PTR [PRU],0	;Installation durchfhren ?
	JZ JA_SIR		;Dann wollen wir einmal
	CMP BYTE PTR [PRU],4	;Nur bei 4 erlaubte Entnahme
	JNZ NOGLUC		;funktioniert nicht
	JMP GLUCK		;doch, Glck gehabt
NOGLUC:	MOV DX,OFFSET PECH	;Fehlermeldung ausgeben
	MOV AH,09H
	INT 21H
	MOV AX,4C01H		;Fehlercode 1
	INT 21H			;beenden

; -------------------------------------------------------------

JA_SIR:	CLI			;Interrupts sperren
	MOV AX,3509H		;Inhalt des alten Interruptes
	INT 21H			;auslesen
	MOV WORD PTR [ALTINT],BX
	MOV WORD PTR [ALTINT+2],ES
				;Offset- und Segmentadresse sichern

	MOV AX,3513H		;Inhalt Diskettenint.
	INT 21H			;lesen
	MOV WORD PTR [ALTI13],BX
	MOV WORD PTR [ALTI13+2],ES
				;Offset- und Segmentadresse sichern
	MOV AX,3510H		;Bildschirmint. lesen
	INT 21H
	MOV WORD PTR [ALTI10],BX
	MOV WORD PTR [ALTI10+2],ES
				;Offset und Segmentadresse sichern
	MOV AX,3528H		;Inhalt wegen COMMAND.COM
	INT 21H			;lesen
	MOV WORD PTR [ALTI28],BX
	MOV WORD PTR [ALTI28+2],ES
				;Offset- und Segmentadresse sichern

	MOV AX,2509H		;Tastaturinterrupt setzen
	MOV DX,OFFSET NEUADR
	INT 21H
	MOV AX,2513H		;Neuer Handler
	MOV DX,OFFSET NEU13	;fr Diskettenint.
	INT 21H
	MOV AX,2510H		;Neuer Handler
	MOV DX,OFFSET NEU10	;fr Bildschirmint.
	INT 21H
	MOV AX,2528H		;Neuer Handler
	MOV DX,OFFSET NEU28	;fr Aufruf aus COMMAND.COM
	INT 21H

	MOV AH,34H		;Adresse INDOS-Flag holen
	INT 21H
	MOV WORD PTR [INDOSS],BX
	MOV WORD PTR [INDOSS+2],ES

	STI			;Interrupts freischalten

	MOV AH,09H		;Erfolgsmeldung ausgeben
	MOV DX,OFFSET ERFOLG
	INT 21H			;fertig

	LEA DX,INSTAL		;residenten Speicherraum ermitteln
	ADD DX,15		;nchsten Paragraphen vollmachen
	MOV CL,4		;logisch schieben (4) = /16
	SHR DX,CL		;das war es

	MOV AX,3100H		;Programm ohne Fehler
	INT 21H			;resident beenden

; ---------------------------
; - Programm reinstallieren -
; ---------------------------

				;Reinstallation kann beginnen
GLUCK:	CLI			;Interrupts sperren
	MOV ES,WORD PTR [HINWE1]	;Segment der TSR-Routine holen
	MOV AX,2509H		;Tastaturint.
	LDS DX,ES:[ALTINT]
	INT 21H			;wiederherstellen
	MOV AX,2513H		;Diskettenint.
	LDS DX,ES:[ALTI13]
	INT 21H			;wiederherstellen
	MOV AX,2510H		;Bildschirmint.
	LDS DX,ES:[ALTI10]
	INT 21H			;wiederherstellen
	MOV AX,2528H		;wegen COMMAND.COM Aufrufsmglichkeit
	LDS DX,ES:[ALTI28]
	INT 21H			;wiederherstellen
	PUSH CS
	POP DS			;Datensegment restaurieren
	MOV BYTE PTR [PRU],0
	PUSH ES			;Segmentadr. des TSR-PSP merken
	MOV ES,ES:[02CH]	;Segadr. Environment aus PSP
	MOV AH,49H		;Speicher freigeben
	INT 21H
	JNC KFEHL1
	INC BYTE PTR [PRU]
KFEHL1:	POP ES			;Segment wiederholen
	MOV AH,49H		;Speicher letztendlich
	INT 21H			;freisetzen
	MOV DX,OFFSET GLUCK1	;Ok, ausgeben
	MOV AL,0		;Ende-Code = 0
	JNC KFEHL
	INC BYTE PTR [PRU]
KFEHL:	CMP BYTE PTR [PRU],0	;zwei Aufrufe ohne Fehler ?
	JZ KFEHL2
	MOV DX,OFFSET PECH1	;Fehler bei der Freigabe aufgetreten
	MOV AL,01		;Fehlercode 1
KFEHL2:	STI			;Interrupts freigeben
	PUSH AX
	MOV AH,09H		;Bildschirmmitteilung ausgeben
	INT 21H
	POP AX
	MOV AH,4CH		;Programm beenden
	INT 21H

; ---------------------------------------------
; - Alle angesprochenen Interrupts berprfen -
; ---------------------------------------------

INSPRU:	CLD			;aufsteigende Stringbearbeitung
	MOV BYTE PTR [PRU],0	;Prfbyte auf Null
	MOV AX,3509H		;INT 09 berprfen
	INT 21H
	CALL LESE		;INT 09H verbogen ?
	MOV AX,3510H		;INT 10H berprfen
	INT 21H
	CALL LESE		;verbogen ?
	MOV AX,3513H		;INT 13H berprfen
	INT 21H
	CALL LESE		;verbogen ?
	MOV AX,3528H		;INT 28H berprfen
	INT 21H

; --------------------------------------------------------------

LESE:	MOV SI,OFFSET PRUEF	;Stringvergleich
	MOV DI,SI		;ob bereits
	MOV CX,7		;installiert ist
	REPE CMPSW		;durchfhren
	JNZ WEITER		;nicht installiert = weiter
	INC [PRU]		;Verschachtelung erhhen
	MOV WORD PTR [HINWE1],ES	;Segment ablegen
WEITER:	RET

; ----------------------------------
; - Variablenteil der Installation -
; ----------------------------------

PECH	DB 13,10,"Reinstallation leider nicht mglich ! Vektoren nicht mehr"
	DB 13,10,"restaurierbar !!!!!!",13,10,"$"
PECH1	DB 13,10,"Reinstallation bei Aufruf der Freigabe fehlgeschlagen."
	DB 13,10,"DOS-interner Fehler aufgetreten!"
	DB 13,10,"Systemabsturz mu einkalkuliert werden.",13,10,"$"
GLUCK1	DB 13,10,"Reinstallation erfolgreich durchgefhrt!,",13,10,"$"
ERFOLG	DB 13,10,"Hotkey-Lehrprogramm resident installiert !",13,10
	DB 13,10,"(C) 1990 INTEREST Verlag"
	DB 13,10,"Aktivierung ber ALT+M"
	DB 13,10,"Programm dient ausschlielich zu Lehrzwecken.",13,10,"$"

HINWE1	DW 0			;Zwischenspeicher fr Segment
PRU	DB 0			;Prfbyte der Handler

; -------------------------------------------------------------

WEIT5	ENDP			;Ende des NEAR-Teiles

CODE	ENDS
	END BEGINN
