 	PAGE	65,160
	TITLE	DISPLAY - Anzeige von Speicherinhalten
	NAME	DISPLAY
;---------------------------------------------------------------------
;
;	Name:		DISPLAY
;	Filename:	DISPLAY.ASM
;
;	Autor:		H.Gschossmann
;
;	Funktion:	Das Programm liest eine Interruptvektornummer ber die
;			Tastatur ein. Die Intersegmentadresse des Vektors und
;			die entsprechenden Speicherbytes werden ausgegeben.
;
;---------------------------------------------------------------------
;	Assemblierungsverhalten
;
		DOSSEG			;DOS Segmentorder
		.MODEL	COMPACT		;mehrere Daten- und ein Codesegment
		.8086			;8086 fhig
		.SALL			;Steuerung Makrolisting

;---------------------------------------------------------------------
;	INCLUDE Dateien
;
		INCLUDE RMEM.ETN	;Speicherleseroutinen

		PAGE
;---------------------------------------------------------------------
;	Stack
;
		.STACK	256

		PAGE
;---------------------------------------------------------------------
;	Konstanten
;
ATTR		EQU	0Fh		;Bildschirmattribut: hell

		
;---------------------------------------------------------------------
;	Daten
;
		.DATA
BeginText	DB	0Ah,0Dh,"Bitte Interruptnummer eingeben (hex): ","$"

Buffer	DB	03h			;Puffer zum Einlesen
		DB	?
		DB	03h DUP (?)

NumberHigh	DB	?		;Zahl hherwertiger Teil
NumberLow	DB	?		;Zahl niederwertiger Teil

IntNum		DB	?		;Interruptnummer

VidMemAdr	LABEL	DWORD
		DW	10*160+10*2	;Ausgabe in Zeile 10 Spalte 10
		DW	0B800h		;Segmentadresse des Bildschirmspeichers
					; (MGA -> 0B000h; CGA -> 0B800h)

InterOffs	DW	?
InterSeg	DW	?

IntText1	DB	"Intersegmentadresse des Vektors "
INTTEXT1_LEN	EQU	$-IntText1

IntText2	DB	"h: "
INTTEXT2_LEN	EQU	$-IntText2

Doppelpunkt	DB	":"

ByteText	DB	"Die vier zugehrigen Bytes im Speicher (low .. high): "
BYTETEXT_LEN	EQU	$-ByteText

		PAGE
;---------------------------------------------------------------------
;	Code
;
		.CODE
;---------------------------------------------------------------------
;
;	Main
;		Siehe Modulfunktion
;		In:	--
;
;		Out:	--
;
;---------------------------------------------------------------------
Main		PROC	NEAR

	mov	ax,@data		;Datensegment einstellen
	mov	ds,ax

; ----	Interruptnummer einlesen
ReadNum:mov	dx,OFFSET BeginText	;Text ausgeben
	mov	ah,09h
	int	21h			;Display String

	mov	dx,OFFSET Buffer	;Nummer einlesen
	mov	ah,0Ah
	int	21h			;Buffered Keyboard Input

; ----	Test, ob es sich um eine Hexzahl handelt und Umwandlung
MainTest:
	mov	bx,dx

	cmp	BYTE PTR [bx+1],00h	;Kein Zeichen eingelesen?
	je	ReadNum			;nein -> nochmals lesen

	cmp	BYTE PTR [bx+1],01h	;Nur ein Zeichen eingelesen?
	jne	MTGo0			;nein -> zwei Zeichen eingelesen
	mov	dl,[bx+2]		;DL := das Zeichen
	cmp	dl," "			;Ein Space?
	je	ReadNum			;ja -> nochmals einlesen
	push	dx			;nein -> Zeichen testen
	call	HexTest
	jc	ReadNum			;Fehler -> nochmals lesen
	mov	NumberHigh,"0"		;zweistellige Ziffer aufbereiten
	mov	NumberLow,dl
	jmp	MainChange

MTGo0:	mov	dl,[bx+2]		;DL := erstes Zeichen
	cmp	dl," "			;Ist erstes Zeichen ein Space?
	jne	MTGo1			;nein -> weiter
	mov	dl,[bx+3]		;ja -> DL := zweites Zeichen
	cmp	dl," "			;Ist zweites Zeichen ein Space?
	je	ReadNum			;ja -> nochmals lesen
	push	dx			;nein -> Zeichen testen
	call	HexTest
	jc	ReadNum			;Fehler -> nochmals lesen
	mov	NumberHigh,"0"		;zweistellige Ziffer aufbereiten
	mov	NumberLow,dl
	jmp	MainChange

MTGo1:	push	dx			;erstes Zeichen testen
	call	HexTest
	jc	ReadNum			;Fehler -> nochmals lesen
	mov	dh,dl			;DH := erstes Zeichen
	mov	dl,[bx+3]		;DL := zweites Zeichen
	cmp	dl," "			;Ist zweites Zeichen ein Space?
	jne	MTGo2			;nein -> weiter
	mov	NumberHigh,"0"		;zweistellige Ziffer aufbereiten
	mov	NumberLow,dh
	jmp	MainChange
	
MTGo2:	push	dx			;Zeichen testen
	call	HexTest
	jc	ReadNum			;Fehler -> nochmals lesen
	mov	NumberHigh,dh		;zweistellige Ziffer aufbereiten
	mov	NumberLow,dl
	
; ----	ASCII Zeichen der Interruptnummer umwandeln in eine hexadezimale Zahl
MainChange:
	mov	dl,NumberLow		;DL := niederwertige Ziffer
	cmp	dl,39h			;Ziffer ein Buchstabe?
	jna	MCGo0			;nein -> weiter
	add	dl,09h
MCGo0:	and	dl,0Fh			;hherwertige Bits ausblenden

	mov	dh,NumberHigh		;DH := hherwertige Ziffer
	cmp	dh,39h			;Ziffer ein Buchstabe?
	jna	MCGo1			;nein -> weiter
	add	dh,09h
MCGo1:	and	dh,0Fh			;hherwertige Bits ausblenden
	mov	cl,04h
	shl	dh,cl
	or	dl,dh
	mov	IntNum,dl
	
; ----	Interruptvektor lesen
	mov	ah,35h			;Get Interrupt Vector
	mov	al,IntNum
	int	21h

	mov	InterOffs,bx		;Intersegmentadresse sichern
	mov	InterSeg,es

; ----	Die Intersegmentadresse des Interruptvektors direkt in den Bild-
;	schirmspeicher schreiben.
	les	bx,VidMemAdr
	xor	cx,cx
; ----	Ersten Teil des Textes ausgeben
TextLoop0:
	mov	al,ATTR
	push	ax
	push	es
	push	bx
	push	ds
	mov	ax,OFFSET IntText1
	add	ax,cx
	push	ax
	call	MemToAscAttr
	add	bx,02h			;Im Videospeicher weiterschalten
	inc	cx
	cmp	cx,INTTEXT1_LEN
	jne	TextLoop0

; ----	Interruptnummer ausgeben
	mov	al,ATTR
	push	ax
	push	es
	push	bx
	push	ds
	mov	ax,OFFSET IntNum
	push	ax
	call	MemToHexAttr
	add	bx,04h			;Im Videospeicher weiterschalten

	xor	cx,cx
TextLoop1:
	mov	al,ATTR
	push	ax
	push	es
	push	bx
	push	ds
	mov	ax,OFFSET IntText2
	add	ax,cx
	push	ax
	call	MemToAscAttr
	add	bx,02h			;Im Videospeicher weiterschalten
	inc	cx
	cmp	cx,INTTEXT2_LEN
	jne	TextLoop1

; ----	Segmentteil ausgeben
	mov	al,ATTR
	push	ax
	push	es
	push	bx
	push	ds
	mov	ax,OFFSET InterSeg
	push	ax
	call	MemWordToHexAttr
	add	bx,08h			;Im Videospeicher weiterschalten

; ----	Einen Doppelpunkt zwischen Segment und Offset ausgeben
	mov	al,ATTR
	push	ax
	push	es
	push	bx
	push	ds
	mov	ax,OFFSET Doppelpunkt
	push	ax
	call	MemToAscAttr
	add	bx,02h			;Im Videospeicher weiterschalten

; ----	Den Offsetteil ausgeben
	mov	al,ATTR
	push	ax
	push	es
	push	bx
	push	ds
	mov	ax,OFFSET InterOffs
	push	ax
	call	MemWordToHexAttr

; ----	Vier Bytes ab der Adresse IntNum*4 in den Bildschirmspeicher
;	schreiben.
	les	bx,VidMemAdr
	add	bx,160			;eine Zeile weiterschalten
	xor	cx,cx

; ----	Den Text ausgeben
TextLoop2:
	mov	al,ATTR
	push	ax
	push	es
	push	bx
	push	ds
	mov	ax,OFFSET ByteText
	add	ax,cx
	push	ax
	call	MemToAscAttr
	add	bx,02h			;Im Videospeicher weiterschalten
	inc	cx
	cmp	cx,BYTETEXT_LEN
	jne	TextLoop2

; ----	Die vier Bytes ausgeben
	xor	cx,cx
ByteLoop0:
	mov	al,ATTR
	push	ax
	push	es
	push	bx
	xor	ax,ax
	push	ax
	xor	ah,ah
	mov	al,IntNum
	shl	ax,1
	shl	ax,1
	add	ax,cx
	push	ax
	call	MemToHexAttr
	add	bx,04h			;Im Videospeicher weiterschalten
	inc	cx
	cmp	cx,04h
	jne	ByteLoop0

	mov	ax,4C00h		;Programmende
	int	21h

Main		ENDP

		PAGE
;---------------------------------------------------------------------
;
;	HexTest
;		Die Routine testet, ob es sich bei dem Wert
;		um ein hexadezimales Zeichen handelt.
;
;		In:	WORD:	im niederwertigen Byte der zu testende Wert
;
;		Out:	Carry:	gelscht	alles o.k.
;			Carry:	gesetzt		kein Hexzeichen
;
;---------------------------------------------------------------------
HexTest		PROC	NEAR

	 push	bp			;Stackframe einrichten
	 mov	bp,sp
	 pushf				;Flags sichern

	mov	ax,[bp+4]		;AL = zu testender Wert
	cmp	al,30h
	jb	HTError
	cmp	al,39h
	jbe	HTEnd
	cmp	al,41h
	jb	HTError
	cmp	al,46h
	jbe	HTEnd
	cmp	al,61h
	jb	HTError
	cmp	al,66h
	jbe	HTEnd

HTError:
	popf				;Flags restaurieren
	stc				;kein Hexzeichen
	pop	bp
	ret	2

HTEnd:
	popf				;Flags restaurieren
	clc				;Hexzeichen
	pop	bp
	ret	2

HexTest		ENDP

;-------------------------- Source - Ende ----------------------------
		END	Main